package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BootstrapRole {

  def apply(
    arn: String,
    bootstrapStackVersionSsmParameter: Option[String] = None,
    requiresBootstrapStackVersion: Option[Number] = None,
    assumeRoleExternalId: Option[String] = None
  ): software.amazon.awscdk.cloudassembly.schema.BootstrapRole =
    (new software.amazon.awscdk.cloudassembly.schema.BootstrapRole.Builder)
      .arn(arn)
      .bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter.orNull)
      .requiresBootstrapStackVersion(requiresBootstrapStackVersion.orNull)
      .assumeRoleExternalId(assumeRoleExternalId.orNull)
      .build()
}
