package io.burkard.cdk.services.xray.cfnSamplingRule

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SamplingRuleProperty {

  def apply(
    ruleName: Option[String] = None,
    serviceType: Option[String] = None,
    priority: Option[Number] = None,
    urlPath: Option[String] = None,
    resourceArn: Option[String] = None,
    serviceName: Option[String] = None,
    host: Option[String] = None,
    httpMethod: Option[String] = None,
    fixedRate: Option[Number] = None,
    attributes: Option[Map[String, String]] = None,
    version: Option[Number] = None,
    ruleArn: Option[String] = None,
    reservoirSize: Option[Number] = None
  ): software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleProperty =
    (new software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleProperty.Builder)
      .ruleName(ruleName.orNull)
      .serviceType(serviceType.orNull)
      .priority(priority.orNull)
      .urlPath(urlPath.orNull)
      .resourceArn(resourceArn.orNull)
      .serviceName(serviceName.orNull)
      .host(host.orNull)
      .httpMethod(httpMethod.orNull)
      .fixedRate(fixedRate.orNull)
      .attributes(attributes.map(_.asJava).orNull)
      .version(version.orNull)
      .ruleArn(ruleArn.orNull)
      .reservoirSize(reservoirSize.orNull)
      .build()
}
