package io.burkard.cdk.services.synthetics.cfnCanary

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VPCConfigProperty {

  def apply(
    securityGroupIds: List[String],
    subnetIds: List[String],
    vpcId: Option[String] = None
  ): software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty =
    (new software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty.Builder)
      .securityGroupIds(securityGroupIds.asJava)
      .subnetIds(subnetIds.asJava)
      .vpcId(vpcId.orNull)
      .build()
}
