package io.burkard.cdk.services.ses.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3 {

  def apply(
    bucket: software.amazon.awscdk.services.s3.IBucket,
    kmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    objectKeyPrefix: Option[String] = None,
    topic: Option[software.amazon.awscdk.services.sns.ITopic] = None
  ): software.amazon.awscdk.services.ses.actions.S3 =
    software.amazon.awscdk.services.ses.actions.S3.Builder
      .create()
      .bucket(bucket)
      .kmsKey(kmsKey.orNull)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .topic(topic.orNull)
      .build()
}
