package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SecretStringGenerator {

  def apply(
    secretStringTemplate: Option[String] = None,
    includeSpace: Option[Boolean] = None,
    excludeLowercase: Option[Boolean] = None,
    excludeCharacters: Option[String] = None,
    generateStringKey: Option[String] = None,
    excludeNumbers: Option[Boolean] = None,
    excludeUppercase: Option[Boolean] = None,
    excludePunctuation: Option[Boolean] = None,
    passwordLength: Option[Number] = None,
    requireEachIncludedType: Option[Boolean] = None
  ): software.amazon.awscdk.services.secretsmanager.SecretStringGenerator =
    (new software.amazon.awscdk.services.secretsmanager.SecretStringGenerator.Builder)
      .secretStringTemplate(secretStringTemplate.orNull)
      .includeSpace(includeSpace.map(Boolean.box).orNull)
      .excludeLowercase(excludeLowercase.map(Boolean.box).orNull)
      .excludeCharacters(excludeCharacters.orNull)
      .generateStringKey(generateStringKey.orNull)
      .excludeNumbers(excludeNumbers.map(Boolean.box).orNull)
      .excludeUppercase(excludeUppercase.map(Boolean.box).orNull)
      .excludePunctuation(excludePunctuation.map(Boolean.box).orNull)
      .passwordLength(passwordLength.orNull)
      .requireEachIncludedType(requireEachIncludedType.map(Boolean.box).orNull)
      .build()
}
