package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGCMChannel {

  def apply(
    internalResourceId: String,
    applicationId: String,
    apiKey: String,
    enabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnGCMChannel =
    software.amazon.awscdk.services.pinpoint.CfnGCMChannel.Builder
      .create(stackCtx, internalResourceId)
      .applicationId(applicationId)
      .apiKey(apiKey)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
