package io.burkard.cdk.services.lambda.nodejs

sealed abstract class OutputFormat(val underlying: software.amazon.awscdk.services.lambda.nodejs.OutputFormat)
  extends Product
    with Serializable

object OutputFormat {
  implicit def toAws(value: OutputFormat): software.amazon.awscdk.services.lambda.nodejs.OutputFormat =
    Option(value).map(_.underlying).orNull

  case object Cjs
    extends OutputFormat(software.amazon.awscdk.services.lambda.nodejs.OutputFormat.CJS)

  case object Esm
    extends OutputFormat(software.amazon.awscdk.services.lambda.nodejs.OutputFormat.ESM)
}
