package io.burkard.cdk.services.guardduty

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDetectorProps {

  def apply(
    enable: Boolean,
    dataSources: Option[software.amazon.awscdk.services.guardduty.CfnDetector.CFNDataSourceConfigurationsProperty] = None,
    findingPublishingFrequency: Option[String] = None
  ): software.amazon.awscdk.services.guardduty.CfnDetectorProps =
    (new software.amazon.awscdk.services.guardduty.CfnDetectorProps.Builder)
      .enable(enable)
      .dataSources(dataSources.orNull)
      .findingPublishingFrequency(findingPublishingFrequency.orNull)
      .build()
}
