package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClusterCapacityProviderAssociations {

  def apply(
    internalResourceId: String,
    cluster: String,
    capacityProviders: List[String],
    defaultCapacityProviderStrategy: List[_]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociations =
    software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociations.Builder
      .create(stackCtx, internalResourceId)
      .cluster(cluster)
      .capacityProviders(capacityProviders.asJava)
      .defaultCapacityProviderStrategy(defaultCapacityProviderStrategy.asJava)
      .build()
}
