package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVPCEndpointServiceProps {

  def apply(
    acceptanceRequired: Option[Boolean] = None,
    gatewayLoadBalancerArns: Option[List[String]] = None,
    networkLoadBalancerArns: Option[List[String]] = None,
    payerResponsibility: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnVPCEndpointServiceProps =
    (new software.amazon.awscdk.services.ec2.CfnVPCEndpointServiceProps.Builder)
      .acceptanceRequired(acceptanceRequired.map(Boolean.box).orNull)
      .gatewayLoadBalancerArns(gatewayLoadBalancerArns.map(_.asJava).orNull)
      .networkLoadBalancerArns(networkLoadBalancerArns.map(_.asJava).orNull)
      .payerResponsibility(payerResponsibility.orNull)
      .build()
}
