package io.burkard.cdk.services.databrew.cfnDataset

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatasetParameterProperty {

  def apply(
    name: String,
    `type`: String,
    createColumn: Option[Boolean] = None,
    filter: Option[software.amazon.awscdk.services.databrew.CfnDataset.FilterExpressionProperty] = None,
    datetimeOptions: Option[software.amazon.awscdk.services.databrew.CfnDataset.DatetimeOptionsProperty] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.DatasetParameterProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.DatasetParameterProperty.Builder)
      .name(name)
      .`type`(`type`)
      .createColumn(createColumn.map(Boolean.box).orNull)
      .filter(filter.orNull)
      .datetimeOptions(datetimeOptions.orNull)
      .build()
}
