package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NumberAttribute {

  def apply(
    min: Option[Number] = None,
    max: Option[Number] = None,
    mutable: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.NumberAttribute =
    software.amazon.awscdk.services.cognito.NumberAttribute.Builder
      .create()
      .min(min.orNull)
      .max(max.orNull)
      .mutable(mutable.map(Boolean.box).orNull)
      .build()
}
