package io.burkard.cdk.services.codeartifact

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomainProps {

  def apply(
    domainName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    encryptionKey: Option[String] = None,
    permissionsPolicyDocument: Option[AnyRef] = None
  ): software.amazon.awscdk.services.codeartifact.CfnDomainProps =
    (new software.amazon.awscdk.services.codeartifact.CfnDomainProps.Builder)
      .domainName(domainName)
      .tags(tags.map(_.asJava).orNull)
      .encryptionKey(encryptionKey.orNull)
      .permissionsPolicyDocument(permissionsPolicyDocument.orNull)
      .build()
}
