package io.burkard.cdk.services.autoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AutoScalingGroup {

  def apply(
    internalResourceId: String,
    machineImage: software.amazon.awscdk.services.ec2.IMachineImage,
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    initOptions: Option[software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions] = None,
    terminationPolicies: Option[List[_ <: software.amazon.awscdk.services.autoscaling.TerminationPolicy]] = None,
    healthCheck: Option[software.amazon.awscdk.services.autoscaling.HealthCheck] = None,
    maxCapacity: Option[Number] = None,
    blockDevices: Option[List[_ <: software.amazon.awscdk.services.autoscaling.BlockDevice]] = None,
    maxInstanceLifetime: Option[software.amazon.awscdk.Duration] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    signals: Option[software.amazon.awscdk.services.autoscaling.Signals] = None,
    userData: Option[software.amazon.awscdk.services.ec2.UserData] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    ignoreUnmodifiedSizeProperties: Option[Boolean] = None,
    associatePublicIpAddress: Option[Boolean] = None,
    minCapacity: Option[Number] = None,
    allowAllOutbound: Option[Boolean] = None,
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    requireImdsv2: Option[Boolean] = None,
    desiredCapacity: Option[Number] = None,
    groupMetrics: Option[List[_ <: software.amazon.awscdk.services.autoscaling.GroupMetrics]] = None,
    keyName: Option[String] = None,
    newInstancesProtectedFromScaleIn: Option[Boolean] = None,
    instanceMonitoring: Option[software.amazon.awscdk.services.autoscaling.Monitoring] = None,
    spotPrice: Option[String] = None,
    notifications: Option[List[_ <: software.amazon.awscdk.services.autoscaling.NotificationConfiguration]] = None,
    autoScalingGroupName: Option[String] = None,
    init: Option[software.amazon.awscdk.services.ec2.CloudFormationInit] = None,
    updatePolicy: Option[software.amazon.awscdk.services.autoscaling.UpdatePolicy] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.autoscaling.AutoScalingGroup =
    software.amazon.awscdk.services.autoscaling.AutoScalingGroup.Builder
      .create(stackCtx, internalResourceId)
      .machineImage(machineImage)
      .instanceType(instanceType)
      .vpc(vpc)
      .initOptions(initOptions.orNull)
      .terminationPolicies(terminationPolicies.map(_.asJava).orNull)
      .healthCheck(healthCheck.orNull)
      .maxCapacity(maxCapacity.orNull)
      .blockDevices(blockDevices.map(_.asJava).orNull)
      .maxInstanceLifetime(maxInstanceLifetime.orNull)
      .role(role.orNull)
      .signals(signals.orNull)
      .userData(userData.orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties.map(Boolean.box).orNull)
      .associatePublicIpAddress(associatePublicIpAddress.map(Boolean.box).orNull)
      .minCapacity(minCapacity.orNull)
      .allowAllOutbound(allowAllOutbound.map(Boolean.box).orNull)
      .cooldown(cooldown.orNull)
      .requireImdsv2(requireImdsv2.map(Boolean.box).orNull)
      .desiredCapacity(desiredCapacity.orNull)
      .groupMetrics(groupMetrics.map(_.asJava).orNull)
      .keyName(keyName.orNull)
      .newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn.map(Boolean.box).orNull)
      .instanceMonitoring(instanceMonitoring.orNull)
      .spotPrice(spotPrice.orNull)
      .notifications(notifications.map(_.asJava).orNull)
      .autoScalingGroupName(autoScalingGroupName.orNull)
      .init(init.orNull)
      .updatePolicy(updatePolicy.orNull)
      .securityGroup(securityGroup.orNull)
      .build()
}
