package io.burkard.cdk.services.appmesh.cfnVirtualNode

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HealthCheckProperty {

  def apply(
    intervalMillis: Number,
    timeoutMillis: Number,
    healthyThreshold: Number,
    unhealthyThreshold: Number,
    protocol: String,
    path: Option[String] = None,
    port: Option[Number] = None
  ): software.amazon.awscdk.services.appmesh.CfnVirtualNode.HealthCheckProperty =
    (new software.amazon.awscdk.services.appmesh.CfnVirtualNode.HealthCheckProperty.Builder)
      .intervalMillis(intervalMillis)
      .timeoutMillis(timeoutMillis)
      .healthyThreshold(healthyThreshold)
      .unhealthyThreshold(unhealthyThreshold)
      .protocol(protocol)
      .path(path.orNull)
      .port(port.orNull)
      .build()
}
