package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TagProps {

  def apply(
    priority: Option[Number] = None,
    includeResourceTypes: Option[List[String]] = None,
    applyToLaunchedInstances: Option[Boolean] = None,
    excludeResourceTypes: Option[List[String]] = None
  ): software.amazon.awscdk.TagProps =
    (new software.amazon.awscdk.TagProps.Builder)
      .priority(priority.orNull)
      .includeResourceTypes(includeResourceTypes.map(_.asJava).orNull)
      .applyToLaunchedInstances(applyToLaunchedInstances.map(Boolean.box).orNull)
      .excludeResourceTypes(excludeResourceTypes.map(_.asJava).orNull)
      .build()
}
