package io.burkard.cdk.services.wafv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRuleGroupProps {

  def apply(
    visibilityConfig: software.amazon.awscdk.services.wafv2.CfnRuleGroup.VisibilityConfigProperty,
    scope: String,
    capacity: Number,
    name: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    customResponseBodies: Option[Map[String, _]] = None,
    rules: Option[List[_]] = None
  ): software.amazon.awscdk.services.wafv2.CfnRuleGroupProps =
    (new software.amazon.awscdk.services.wafv2.CfnRuleGroupProps.Builder)
      .visibilityConfig(visibilityConfig)
      .scope(scope)
      .capacity(capacity)
      .name(name.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .customResponseBodies(customResponseBodies.map(_.asJava).orNull)
      .rules(rules.map(_.asJava).orNull)
      .build()
}
