package io.burkard.cdk.services.ses

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReceiptRuleSetProps {

  def apply(
    rules: Option[List[_ <: software.amazon.awscdk.services.ses.ReceiptRuleOptions]] = None,
    receiptRuleSetName: Option[String] = None,
    dropSpam: Option[Boolean] = None
  ): software.amazon.awscdk.services.ses.ReceiptRuleSetProps =
    (new software.amazon.awscdk.services.ses.ReceiptRuleSetProps.Builder)
      .rules(rules.map(_.asJava).orNull)
      .receiptRuleSetName(receiptRuleSetName.orNull)
      .dropSpam(dropSpam.map(Boolean.box).orNull)
      .build()
}
