package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioShareProps {

  def apply(
    accountId: String,
    portfolioId: String,
    acceptLanguage: Option[String] = None,
    shareTagOptions: Option[Boolean] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioShareProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioShareProps.Builder)
      .accountId(accountId)
      .portfolioId(portfolioId)
      .acceptLanguage(acceptLanguage.orNull)
      .shareTagOptions(shareTagOptions.map(Boolean.box).orNull)
      .build()
}
