package io.burkard.cdk.services.refactorspaces

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEnvironmentProps {

  def apply(
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    networkFabricType: Option[String] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnEnvironmentProps =
    (new software.amazon.awscdk.services.refactorspaces.CfnEnvironmentProps.Builder)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .networkFabricType(networkFabricType.orNull)
      .build()
}
