package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonGrantOptions {

  def apply(
    actions: List[String],
    grantee: software.amazon.awscdk.services.iam.IGrantable,
    resourceArns: List[String]
  ): software.amazon.awscdk.services.iam.CommonGrantOptions =
    (new software.amazon.awscdk.services.iam.CommonGrantOptions.Builder)
      .actions(actions.asJava)
      .grantee(grantee)
      .resourceArns(resourceArns.asJava)
      .build()
}
