package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StandardAttributesMask {

  def apply(
    familyName: Option[Boolean] = None,
    website: Option[Boolean] = None,
    givenName: Option[Boolean] = None,
    emailVerified: Option[Boolean] = None,
    phoneNumber: Option[Boolean] = None,
    middleName: Option[Boolean] = None,
    email: Option[Boolean] = None,
    lastUpdateTime: Option[Boolean] = None,
    phoneNumberVerified: Option[Boolean] = None,
    timezone: Option[Boolean] = None,
    profilePicture: Option[Boolean] = None,
    locale: Option[Boolean] = None,
    birthdate: Option[Boolean] = None,
    fullname: Option[Boolean] = None,
    profilePage: Option[Boolean] = None,
    address: Option[Boolean] = None,
    preferredUsername: Option[Boolean] = None,
    gender: Option[Boolean] = None,
    nickname: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.StandardAttributesMask =
    (new software.amazon.awscdk.services.cognito.StandardAttributesMask.Builder)
      .familyName(familyName.map(Boolean.box).orNull)
      .website(website.map(Boolean.box).orNull)
      .givenName(givenName.map(Boolean.box).orNull)
      .emailVerified(emailVerified.map(Boolean.box).orNull)
      .phoneNumber(phoneNumber.map(Boolean.box).orNull)
      .middleName(middleName.map(Boolean.box).orNull)
      .email(email.map(Boolean.box).orNull)
      .lastUpdateTime(lastUpdateTime.map(Boolean.box).orNull)
      .phoneNumberVerified(phoneNumberVerified.map(Boolean.box).orNull)
      .timezone(timezone.map(Boolean.box).orNull)
      .profilePicture(profilePicture.map(Boolean.box).orNull)
      .locale(locale.map(Boolean.box).orNull)
      .birthdate(birthdate.map(Boolean.box).orNull)
      .fullname(fullname.map(Boolean.box).orNull)
      .profilePage(profilePage.map(Boolean.box).orNull)
      .address(address.map(Boolean.box).orNull)
      .preferredUsername(preferredUsername.map(Boolean.box).orNull)
      .gender(gender.map(Boolean.box).orNull)
      .nickname(nickname.map(Boolean.box).orNull)
      .build()
}
