package io.burkard.cdk.services.route53.patterns

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpsRedirectProps {

  def apply(
    zone: software.amazon.awscdk.services.route53.IHostedZone,
    targetDomain: String,
    recordNames: Option[List[String]] = None,
    certificate: Option[software.amazon.awscdk.services.certificatemanager.ICertificate] = None
  ): software.amazon.awscdk.services.route53.patterns.HttpsRedirectProps =
    (new software.amazon.awscdk.services.route53.patterns.HttpsRedirectProps.Builder)
      .zone(zone)
      .targetDomain(targetDomain)
      .recordNames(recordNames.map(_.asJava).orNull)
      .certificate(certificate.orNull)
      .build()
}
