package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGCMChannelProps {

  def apply(
    applicationId: String,
    apiKey: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnGCMChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnGCMChannelProps.Builder)
      .applicationId(applicationId)
      .apiKey(apiKey)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
