package io.burkard.cdk.services.neptune

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDBClusterParameterGroupProps {

  def apply(
    description: String,
    family: String,
    parameters: AnyRef,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.neptune.CfnDBClusterParameterGroupProps =
    (new software.amazon.awscdk.services.neptune.CfnDBClusterParameterGroupProps.Builder)
      .description(description)
      .family(family)
      .parameters(parameters)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
