package io.burkard.cdk.services.msk.cfnCluster

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TlsProperty {

  def apply(
    enabled: Option[Boolean] = None,
    certificateAuthorityArnList: Option[List[String]] = None
  ): software.amazon.awscdk.services.msk.CfnCluster.TlsProperty =
    (new software.amazon.awscdk.services.msk.CfnCluster.TlsProperty.Builder)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .certificateAuthorityArnList(certificateAuthorityArnList.map(_.asJava).orNull)
      .build()
}
