package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogStream {

  def apply(
    internalResourceId: String,
    logGroup: software.amazon.awscdk.services.logs.ILogGroup,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    logStreamName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.logs.LogStream =
    software.amazon.awscdk.services.logs.LogStream.Builder
      .create(stackCtx, internalResourceId)
      .logGroup(logGroup)
      .removalPolicy(removalPolicy.orNull)
      .logStreamName(logStreamName.orNull)
      .build()
}
