package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRouteCalculatorProps {

  def apply(
    pricingPlan: String,
    calculatorName: String,
    dataSource: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnRouteCalculatorProps =
    (new software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder)
      .pricingPlan(pricingPlan)
      .calculatorName(calculatorName)
      .dataSource(dataSource)
      .description(description.orNull)
      .build()
}
