package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPlaceIndexProps {

  def apply(
    dataSource: String,
    indexName: String,
    pricingPlan: String,
    description: Option[String] = None,
    dataSourceConfiguration: Option[software.amazon.awscdk.services.location.CfnPlaceIndex.DataSourceConfigurationProperty] = None
  ): software.amazon.awscdk.services.location.CfnPlaceIndexProps =
    (new software.amazon.awscdk.services.location.CfnPlaceIndexProps.Builder)
      .dataSource(dataSource)
      .indexName(indexName)
      .pricingPlan(pricingPlan)
      .description(description.orNull)
      .dataSourceConfiguration(dataSourceConfiguration.orNull)
      .build()
}
