package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ManagedKafkaEventSourceProps {

  def apply(
    clusterArn: String,
    secret: Option[software.amazon.awscdk.services.secretsmanager.ISecret] = None,
    batchSize: Option[Number] = None,
    enabled: Option[Boolean] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    startingPosition: Option[software.amazon.awscdk.services.lambda.StartingPosition] = None,
    topic: Option[String] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IEventSourceDlq] = None
  ): software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps.Builder)
      .clusterArn(clusterArn)
      .secret(secret.orNull)
      .batchSize(batchSize.orNull)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .startingPosition(startingPosition.orNull)
      .topic(topic.orNull)
      .onFailure(onFailure.orNull)
      .build()
}
