package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClusterCapacityProviderAssociationsProps {

  def apply(
    cluster: String,
    defaultCapacityProviderStrategy: List[_],
    capacityProviders: List[String]
  ): software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociationsProps =
    (new software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociationsProps.Builder)
      .cluster(cluster)
      .defaultCapacityProviderStrategy(defaultCapacityProviderStrategy.asJava)
      .capacityProviders(capacityProviders.asJava)
      .build()
}
