package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIPAMAllocationProps {

  def apply(
    ipamPoolId: String,
    description: Option[String] = None,
    cidr: Option[String] = None,
    netmaskLength: Option[Number] = None
  ): software.amazon.awscdk.services.ec2.CfnIPAMAllocationProps =
    (new software.amazon.awscdk.services.ec2.CfnIPAMAllocationProps.Builder)
      .ipamPoolId(ipamPoolId)
      .description(description.orNull)
      .cidr(cidr.orNull)
      .netmaskLength(netmaskLength.orNull)
      .build()
}
