package io.burkard.cdk.services.codepipeline

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonActionProps {

  def apply(
    actionName: String,
    runOrder: Option[Number] = None,
    variablesNamespace: Option[String] = None
  ): software.amazon.awscdk.services.codepipeline.CommonActionProps =
    (new software.amazon.awscdk.services.codepipeline.CommonActionProps.Builder)
      .actionName(actionName)
      .runOrder(runOrder.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .build()
}
