package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioProductAssociationProps {

  def apply(
    productId: String,
    portfolioId: String,
    sourcePortfolioId: Option[String] = None,
    acceptLanguage: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps.Builder)
      .productId(productId)
      .portfolioId(portfolioId)
      .sourcePortfolioId(sourcePortfolioId.orNull)
      .acceptLanguage(acceptLanguage.orNull)
      .build()
}
