package io.burkard.cdk.services.s3objectlambda.cfnAccessPoint

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ObjectLambdaConfigurationProperty {

  def apply(
    supportingAccessPoint: String,
    transformationConfigurations: List[_],
    allowedFeatures: Option[List[String]] = None,
    cloudWatchMetricsEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty =
    (new software.amazon.awscdk.services.s3objectlambda.CfnAccessPoint.ObjectLambdaConfigurationProperty.Builder)
      .supportingAccessPoint(supportingAccessPoint)
      .transformationConfigurations(transformationConfigurations.asJava)
      .allowedFeatures(allowedFeatures.map(_.asJava).orNull)
      .cloudWatchMetricsEnabled(cloudWatchMetricsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
