package io.burkard.cdk.services.lightsail.cfnInstance

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HardwareProperty {

  def apply(
    ramSizeInGb: Option[Number] = None,
    cpuCount: Option[Number] = None,
    disks: Option[List[_]] = None
  ): software.amazon.awscdk.services.lightsail.CfnInstance.HardwareProperty =
    (new software.amazon.awscdk.services.lightsail.CfnInstance.HardwareProperty.Builder)
      .ramSizeInGb(ramSizeInGb.orNull)
      .cpuCount(cpuCount.orNull)
      .disks(disks.map(_.asJava).orNull)
      .build()
}
