package io.burkard.cdk.services.lex.cfnBot

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WaitAndContinueSpecificationProperty {

  def apply(
    waitingResponse: software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty,
    continueResponse: software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty,
    isActive: Option[Boolean] = None,
    stillWaitingResponse: Option[software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.WaitAndContinueSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.WaitAndContinueSpecificationProperty.Builder)
      .waitingResponse(waitingResponse)
      .continueResponse(continueResponse)
      .isActive(isActive.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .stillWaitingResponse(stillWaitingResponse.orNull)
      .build()
}
