package io.burkard.cdk.services.fis.cfnExperimentTemplate

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ExperimentTemplateTargetProperty {

  def apply(
    resourceType: String,
    selectionMode: String,
    resourceArns: Option[List[String]] = None,
    resourceTags: Option[Map[String, String]] = None,
    filters: Option[List[_]] = None
  ): software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty =
    (new software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty.Builder)
      .resourceType(resourceType)
      .selectionMode(selectionMode)
      .resourceArns(resourceArns.map(_.asJava).orNull)
      .resourceTags(resourceTags.map(_.asJava).orNull)
      .filters(filters.map(_.asJava).orNull)
      .build()
}
