package io.burkard.cdk.services.emr.cfnCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VolumeSpecificationProperty {

  def apply(
    sizeInGb: Number,
    volumeType: String,
    iops: Option[Number] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.VolumeSpecificationProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.VolumeSpecificationProperty.Builder)
      .sizeInGb(sizeInGb)
      .volumeType(volumeType)
      .iops(iops.orNull)
      .build()
}
