package io.burkard.cdk.services.elasticbeanstalk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationVersionProps {

  def apply(
    sourceBundle: software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty,
    applicationName: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps =
    (new software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps.Builder)
      .sourceBundle(sourceBundle)
      .applicationName(applicationName)
      .description(description.orNull)
      .build()
}
