package io.burkard.cdk.services.elasticbeanstalk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplication {

  def apply(
    internalResourceId: String,
    description: Option[String] = None,
    resourceLifecycleConfig: Option[software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty] = None,
    applicationName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.elasticbeanstalk.CfnApplication =
    software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.Builder
      .create(stackCtx, internalResourceId)
      .description(description.orNull)
      .resourceLifecycleConfig(resourceLifecycleConfig.orNull)
      .applicationName(applicationName.orNull)
      .build()
}
