package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnReplicationGroupProps {

  def apply(
    replicationGroupDescription: String,
    snapshotArns: Option[List[String]] = None,
    transitEncryptionEnabled: Option[Boolean] = None,
    cacheParameterGroupName: Option[String] = None,
    authToken: Option[String] = None,
    atRestEncryptionEnabled: Option[Boolean] = None,
    primaryClusterId: Option[String] = None,
    userGroupIds: Option[List[String]] = None,
    cacheSubnetGroupName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    numNodeGroups: Option[Number] = None,
    snapshotWindow: Option[String] = None,
    preferredCacheClusterAZs: Option[List[String]] = None,
    securityGroupIds: Option[List[String]] = None,
    automaticFailoverEnabled: Option[Boolean] = None,
    preferredMaintenanceWindow: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    numCacheClusters: Option[Number] = None,
    notificationTopicArn: Option[String] = None,
    nodeGroupConfiguration: Option[List[_]] = None,
    port: Option[Number] = None,
    snapshotRetentionLimit: Option[Number] = None,
    dataTieringEnabled: Option[Boolean] = None,
    replicationGroupId: Option[String] = None,
    logDeliveryConfigurations: Option[List[_]] = None,
    snapshottingClusterId: Option[String] = None,
    globalReplicationGroupId: Option[String] = None,
    snapshotName: Option[String] = None,
    cacheSecurityGroupNames: Option[List[String]] = None,
    kmsKeyId: Option[String] = None,
    cacheNodeType: Option[String] = None,
    replicasPerNodeGroup: Option[Number] = None,
    engineVersion: Option[String] = None,
    multiAzEnabled: Option[Boolean] = None,
    engine: Option[String] = None
  ): software.amazon.awscdk.services.elasticache.CfnReplicationGroupProps =
    (new software.amazon.awscdk.services.elasticache.CfnReplicationGroupProps.Builder)
      .replicationGroupDescription(replicationGroupDescription)
      .snapshotArns(snapshotArns.map(_.asJava).orNull)
      .transitEncryptionEnabled(transitEncryptionEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cacheParameterGroupName(cacheParameterGroupName.orNull)
      .authToken(authToken.orNull)
      .atRestEncryptionEnabled(atRestEncryptionEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .primaryClusterId(primaryClusterId.orNull)
      .userGroupIds(userGroupIds.map(_.asJava).orNull)
      .cacheSubnetGroupName(cacheSubnetGroupName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .numNodeGroups(numNodeGroups.orNull)
      .snapshotWindow(snapshotWindow.orNull)
      .preferredCacheClusterAZs(preferredCacheClusterAZs.map(_.asJava).orNull)
      .securityGroupIds(securityGroupIds.map(_.asJava).orNull)
      .automaticFailoverEnabled(automaticFailoverEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .autoMinorVersionUpgrade(autoMinorVersionUpgrade.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .numCacheClusters(numCacheClusters.orNull)
      .notificationTopicArn(notificationTopicArn.orNull)
      .nodeGroupConfiguration(nodeGroupConfiguration.map(_.asJava).orNull)
      .port(port.orNull)
      .snapshotRetentionLimit(snapshotRetentionLimit.orNull)
      .dataTieringEnabled(dataTieringEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .replicationGroupId(replicationGroupId.orNull)
      .logDeliveryConfigurations(logDeliveryConfigurations.map(_.asJava).orNull)
      .snapshottingClusterId(snapshottingClusterId.orNull)
      .globalReplicationGroupId(globalReplicationGroupId.orNull)
      .snapshotName(snapshotName.orNull)
      .cacheSecurityGroupNames(cacheSecurityGroupNames.map(_.asJava).orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .cacheNodeType(cacheNodeType.orNull)
      .replicasPerNodeGroup(replicasPerNodeGroup.orNull)
      .engineVersion(engineVersion.orNull)
      .multiAzEnabled(multiAzEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .engine(engine.orNull)
      .build()
}
