package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTrafficMirrorTargetProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    networkLoadBalancerArn: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnTrafficMirrorTargetProps =
    (new software.amazon.awscdk.services.ec2.CfnTrafficMirrorTargetProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .networkInterfaceId(networkInterfaceId.orNull)
      .networkLoadBalancerArn(networkLoadBalancerArn.orNull)
      .build()
}
