package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIPAMAllocation {

  def apply(
    internalResourceId: String,
    ipamPoolId: String,
    description: Option[String] = None,
    cidr: Option[String] = None,
    netmaskLength: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnIPAMAllocation =
    software.amazon.awscdk.services.ec2.CfnIPAMAllocation.Builder
      .create(stackCtx, internalResourceId)
      .ipamPoolId(ipamPoolId)
      .description(description.orNull)
      .cidr(cidr.orNull)
      .netmaskLength(netmaskLength.orNull)
      .build()
}
