package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunctionProps {

  def apply(
    name: String,
    functionConfig: Option[software.amazon.awscdk.services.cloudfront.CfnFunction.FunctionConfigProperty] = None,
    autoPublish: Option[Boolean] = None,
    functionCode: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.CfnFunctionProps =
    (new software.amazon.awscdk.services.cloudfront.CfnFunctionProps.Builder)
      .name(name)
      .functionConfig(functionConfig.orNull)
      .autoPublish(autoPublish.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .functionCode(functionCode.orNull)
      .build()
}
