package io.burkard.cdk.services.autoscaling.cfnLaunchConfiguration

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockDeviceMappingProperty {

  def apply(
    deviceName: String,
    virtualName: Option[String] = None,
    ebs: Option[software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.BlockDeviceProperty] = None,
    noDevice: Option[Boolean] = None
  ): software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.BlockDeviceMappingProperty =
    (new software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.BlockDeviceMappingProperty.Builder)
      .deviceName(deviceName)
      .virtualName(virtualName.orNull)
      .ebs(ebs.orNull)
      .noDevice(noDevice.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
