package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MethodResponse {

  def apply(
    statusCode: String,
    responseParameters: Option[Map[String, _ <: Boolean]] = None,
    responseModels: Option[Map[String, _ <: software.amazon.awscdk.services.apigateway.IModel]] = None
  ): software.amazon.awscdk.services.apigateway.MethodResponse =
    (new software.amazon.awscdk.services.apigateway.MethodResponse.Builder)
      .statusCode(statusCode)
      .responseParameters(responseParameters.map(_.mapValues(Boolean.box).toMap.asJava).orNull)
      .responseModels(responseModels.map(_.asJava).orNull)
      .build()
}
