package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetLocation {

  def apply(
    httpUrl: String,
    bucketName: String,
    objectKey: String,
    s3ObjectUrl: String
  ): software.amazon.awscdk.FileAssetLocation =
    (new software.amazon.awscdk.FileAssetLocation.Builder)
      .httpUrl(httpUrl)
      .bucketName(bucketName)
      .objectKey(objectKey)
      .s3ObjectUrl(s3ObjectUrl)
      .build()
}
