package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CopyOptions {

  def apply(
    exclude: Option[List[String]] = None,
    follow: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None
  ): software.amazon.awscdk.CopyOptions =
    (new software.amazon.awscdk.CopyOptions.Builder)
      .exclude(exclude.map(_.asJava).orNull)
      .follow(follow.orNull)
      .ignoreMode(ignoreMode.orNull)
      .build()
}
