package io.burkard.cdk.services.timestream.cfnScheduledQuery

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MixedMeasureMappingProperty {

  def apply(
    measureValueType: String,
    multiMeasureAttributeMappings: Option[List[_]] = None,
    measureName: Option[String] = None,
    targetMeasureName: Option[String] = None,
    sourceColumn: Option[String] = None
  ): software.amazon.awscdk.services.timestream.CfnScheduledQuery.MixedMeasureMappingProperty =
    (new software.amazon.awscdk.services.timestream.CfnScheduledQuery.MixedMeasureMappingProperty.Builder)
      .measureValueType(measureValueType)
      .multiMeasureAttributeMappings(multiMeasureAttributeMappings.map(_.asJava).orNull)
      .measureName(measureName.orNull)
      .targetMeasureName(targetMeasureName.orNull)
      .sourceColumn(sourceColumn.orNull)
      .build()
}
